// PCW99_ODBC_Generic_DSS_Select.cpp

#include "stdafx.h"
#include "PCW99_ODBC_Generic.h"
#include "PCW99_ODBC_Generic_DSS_Select.h"

// IMPLEMENT_SERIAL macro calls
IMPLEMENT_SERIAL(CXact_DSS_Select_01,CXact,1)
IMPLEMENT_SERIAL(CXact_DSS_Select_02,CXact,1)
IMPLEMENT_SERIAL(CXact_DSS_Select_03,CXact,1)
IMPLEMENT_SERIAL(CXact_DSS_Select_04,CXact,1)
IMPLEMENT_SERIAL(CXact_DSS_Select_05,CXact,1)
IMPLEMENT_SERIAL(CXact_DSS_Select_06,CXact,1)
IMPLEMENT_SERIAL(CXact_DSS_Select_07,CXact,1)
IMPLEMENT_SERIAL(CXact_DSS_Select_08,CXact,1)
IMPLEMENT_SERIAL(CXact_DSS_Select_09,CXact,1)
IMPLEMENT_SERIAL(CXact_DSS_Select_10,CXact,1)
IMPLEMENT_SERIAL(CXact_DSS_Select_11,CXact,1)

// ================================================================================

// CXact_DSS_Select_01

CXact_DSS_Select_01::CXact_DSS_Select_01 (void)
{
	m_szName		= "DSS Select 01";
	m_szDescription = "select count(t_key) from tenpct where t_key <> 0";
	m_szSQL			= "select count(t_key) from tenpct where t_key <> 0";
	m_nXactType		= TRANSACTION;
	m_nXID			= XID_DSS_SELECT+01;
	m_nGID			= DSSSelect;
}

CXact_DSS_Select_01::~CXact_DSS_Select_01 (void)
{
}

BOOL CXact_DSS_Select_01::PreBenchmark (void)
{
	return TRUE;
}

BOOL CXact_DSS_Select_01::PostBenchmark (void)
{
	return TRUE;
}

BOOL CXact_DSS_Select_01::Execute (void)
{

	// declare variables
	CSSOdbcDriver *pSQLDatabaseServer;
	SQLHSTMT hstmt;
	int iRowLoop;
	int ReturnCode;
	struct DSS_SELECT_01 {
		SQLINTEGER count_t_key;
	};
	typedef struct DSS_SELECT_01 DSS_SELECT_01;
	struct DSS_SELECT_01_INDICATORS {
		SQLINTEGER count_t_key;
	};
	typedef struct DSS_SELECT_01_INDICATORS DSS_SELECT_01_INDICATORS;
	DSS_SELECT_01 dss_select_01_array[NUM_ROWS];
	DSS_SELECT_01_INDICATORS dss_select_01_indicators_array[NUM_ROWS];
	SQLUSMALLINT row_status_array[NUM_ROWS];

	// initialize variables
	pSQLDatabaseServer = (CSSOdbcDriver*) m_pCSQLObject;
	
	// allocate a statement handle
	ReturnCode = SQLAllocHandle (SQL_HANDLE_STMT, pSQLDatabaseServer->GetDatabaseHandle(), &hstmt);
	CHECK_FOR_ERROR (hstmt);

	// set statement attributes
	ReturnCode = SQLSetStmtAttr (hstmt, SQL_ATTR_ROW_BIND_TYPE, (PTR)sizeof(dss_select_01_array[0]), SQL_IS_INTEGER);
	CHECK_FOR_ERROR (hstmt);
	ReturnCode = SQLSetStmtAttr (hstmt, SQL_ATTR_ROW_ARRAY_SIZE, (PTR)NUM_ROWS, SQL_IS_INTEGER);
	CHECK_FOR_ERROR (hstmt);
	ReturnCode = SQLSetStmtAttr (hstmt, SQL_ATTR_ROW_STATUS_PTR, row_status_array, SQL_IS_POINTER);
	CHECK_FOR_ERROR (hstmt);

	// prepare the statement	
	ReturnCode = SQLPrepare (hstmt, (UCHAR *)m_szSQL.GetBuffer(0), SQL_NTS);
	m_szSQL.ReleaseBuffer();
	CHECK_FOR_ERROR (hstmt);
	
	// bind output variables
	ReturnCode = SQLBindCol (hstmt, 1, SQL_C_SLONG, &dss_select_01_array[0].count_t_key, sizeof(dss_select_01_array[0].count_t_key), &dss_select_01_indicators_array[0].count_t_key);
	CHECK_FOR_ERROR (hstmt);

	// ==========
	
	// initialize variables
	m_nUnits = 0;

	// start timer
	m_CTimer.SetStartTime();

	// execute the statement
	ReturnCode = SQLExecute (hstmt);
	CHECK_FOR_ERROR_EXECUTE (hstmt);

	// fetch loop
	while (TRUE) {

		// check for user cancel
		if (CancelXact()) {
				m_CTimer.SetEndTime(m_nUnits, m_nBytes);
				ReturnCode = SQLFreeHandle (SQL_HANDLE_STMT, hstmt);
				CHECK_FOR_ERROR (hstmt);
				return FALSE;
		}

		// fetch the data
		ReturnCode = SQLFetchScroll (hstmt, SQL_FETCH_NEXT, IGNORE);
		CHECK_FOR_ERROR_FETCH (hstmt);

		// if no more data, exit loop
		if (ReturnCode == SQL_NO_DATA)
			break;

		// otherwise, count number of rows returned
		for (iRowLoop = 0; row_status_array[iRowLoop] != SQL_ROW_NOROW && iRowLoop < NUM_ROWS; iRowLoop++) {
			m_nUnits++;
		}

		// if this is the first time through, record response time
		if (m_nUnits <= NUM_ROWS)
			m_CTimer.SetResponseTime();

		// output data to log if requested
		if (OutputResults())
			for (iRowLoop = 0; row_status_array[iRowLoop] != SQL_ROW_NOROW && iRowLoop < NUM_ROWS; iRowLoop++) {
				GetResultsFile() 
					<< dss_select_01_array[iRowLoop].count_t_key << endl;
		}

	}

	// update statistics
	m_nBytes = m_nUnits * sizeof(dss_select_01_array[0]);

	// set end time
	m_CTimer.SetEndTime (m_nUnits, m_nBytes);

	// free handle
	ReturnCode = SQLFreeHandle (SQL_HANDLE_STMT, hstmt);
	CHECK_FOR_ERROR (hstmt);

	// return
	return TRUE;

}

// ================================================================================

// CXact_DSS_Select_02

CXact_DSS_Select_02::CXact_DSS_Select_02 (void)
{
	m_szName		= "DSS Select 02";
	m_szDescription = "select min(u_key) from uniques";
	m_szSQL			= "select min(u_key) from uniques";
	m_nXactType		= TRANSACTION;
	m_nXID			= XID_DSS_SELECT+02;
	m_nGID			= DSSSelect;
}

CXact_DSS_Select_02::~CXact_DSS_Select_02 (void)
{
}

BOOL CXact_DSS_Select_02::PreBenchmark (void)
{
	return TRUE;
}

BOOL CXact_DSS_Select_02::PostBenchmark (void)
{
	return TRUE;
}

BOOL CXact_DSS_Select_02::Execute (void)
{

	// declare variables
	CSSOdbcDriver *pSQLDatabaseServer;
	SQLHSTMT hstmt;
	int iRowLoop;
	int ReturnCode;
	struct DSS_SELECT_02 {
		SQLINTEGER min_u_key;
	};
	typedef struct DSS_SELECT_02 DSS_SELECT_02;
	struct DSS_SELECT_02_INDICATORS {
		SQLINTEGER min_u_key;
	};
	typedef struct DSS_SELECT_02_INDICATORS DSS_SELECT_02_INDICATORS;
	DSS_SELECT_02 dss_select_02_array[NUM_ROWS];
	DSS_SELECT_02_INDICATORS dss_select_02_indicators_array[NUM_ROWS];
	SQLUSMALLINT row_status_array[NUM_ROWS];

	// initialize variables
	pSQLDatabaseServer = (CSSOdbcDriver*) m_pCSQLObject;
	
	// allocate a statement handle
	ReturnCode = SQLAllocHandle (SQL_HANDLE_STMT, pSQLDatabaseServer->GetDatabaseHandle(), &hstmt);
	CHECK_FOR_ERROR (hstmt);

	// set statement attributes
	ReturnCode = SQLSetStmtAttr (hstmt, SQL_ATTR_ROW_BIND_TYPE, (PTR)sizeof(dss_select_02_array[0]), SQL_IS_INTEGER);
	CHECK_FOR_ERROR (hstmt);
	ReturnCode = SQLSetStmtAttr (hstmt, SQL_ATTR_ROW_ARRAY_SIZE, (PTR)NUM_ROWS, SQL_IS_INTEGER);
	CHECK_FOR_ERROR (hstmt);
	ReturnCode = SQLSetStmtAttr (hstmt, SQL_ATTR_ROW_STATUS_PTR, row_status_array, SQL_IS_POINTER);
	CHECK_FOR_ERROR (hstmt);
	
	// prepare the statement	
	ReturnCode = SQLPrepare (hstmt, (UCHAR *)m_szSQL.GetBuffer(0), SQL_NTS);
	m_szSQL.ReleaseBuffer();
	CHECK_FOR_ERROR (hstmt);
	
	// bind output variables
	ReturnCode = SQLBindCol (hstmt, 1, SQL_C_SLONG, &dss_select_02_array[0].min_u_key, sizeof(dss_select_02_array[0].min_u_key), &dss_select_02_indicators_array[0].min_u_key);
	CHECK_FOR_ERROR (hstmt);

	// ==========
	
	// initialize variables
	m_nUnits = 0;

	// start timer
	m_CTimer.SetStartTime();

	// execute the statement
	ReturnCode = SQLExecute (hstmt);
	CHECK_FOR_ERROR_EXECUTE (hstmt);

	// fetch loop
	while (TRUE) {

		// check for user cancel
		if (CancelXact()) {
				m_CTimer.SetEndTime(m_nUnits, m_nBytes);
				ReturnCode = SQLFreeHandle (SQL_HANDLE_STMT, hstmt);
				CHECK_FOR_ERROR (hstmt);
				return FALSE;
		}

		// fetch the data
		ReturnCode = SQLFetchScroll (hstmt, SQL_FETCH_NEXT, IGNORE);
		CHECK_FOR_ERROR_FETCH (hstmt);

		// if no more data, exit loop
		if (ReturnCode == SQL_NO_DATA)
			break;

		// otherwise, count number of rows returned
		for (iRowLoop = 0; row_status_array[iRowLoop] != SQL_ROW_NOROW && iRowLoop < NUM_ROWS; iRowLoop++) {
			m_nUnits++;
		}

		// if this is the first time through, record response time
		if (m_nUnits <= NUM_ROWS)
			m_CTimer.SetResponseTime();

		// output data to log if requested
		if (OutputResults())
			for (iRowLoop = 0; row_status_array[iRowLoop] != SQL_ROW_NOROW && iRowLoop < NUM_ROWS; iRowLoop++) {
				GetResultsFile() 
					<< dss_select_02_array[iRowLoop].min_u_key << endl;
		}

	}

	// update statistics
	m_nBytes = m_nUnits * sizeof(dss_select_02_array[0]);

	// set end time
	m_CTimer.SetEndTime (m_nUnits, m_nBytes);

	// free handle
	ReturnCode = SQLFreeHandle (SQL_HANDLE_STMT, hstmt);
	CHECK_FOR_ERROR (hstmt);

	// return
	return TRUE;

}

// ================================================================================

// CXact_DSS_Select_03

CXact_DSS_Select_03::CXact_DSS_Select_03 (void)
{
	m_szName		= "DSS Select 03";
	m_szDescription = "select max(h_key) from hundred group by h_name order by 1";
	m_szSQL			= "select max(h_key) from hundred group by h_name order by 1";
	m_nXactType		= TRANSACTION;
	m_nXID			= XID_DSS_SELECT+03;
	m_nGID			= DSSSelect;
}

CXact_DSS_Select_03::~CXact_DSS_Select_03 (void)
{
}

BOOL CXact_DSS_Select_03::PreBenchmark (void)
{
	return TRUE;
}

BOOL CXact_DSS_Select_03::PostBenchmark (void)
{
	return TRUE;
}

BOOL CXact_DSS_Select_03::Execute (void)
{

	// declare variables
	CSSOdbcDriver *pSQLDatabaseServer;
	SQLHSTMT hstmt;
	int iRowLoop;
	int ReturnCode;
	struct DSS_SELECT_03 {
		SQLINTEGER max_h_key;
	};
	typedef struct DSS_SELECT_03 DSS_SELECT_03;
	struct DSS_SELECT_03_INDICATORS {
		SQLINTEGER max_h_key;
	};
	typedef struct DSS_SELECT_03_INDICATORS DSS_SELECT_03_INDICATORS;
	DSS_SELECT_03 dss_select_03_array[NUM_ROWS];
	DSS_SELECT_03_INDICATORS dss_select_03_indicators_array[NUM_ROWS];
	SQLUSMALLINT row_status_array[NUM_ROWS];

	// initialize variables
	pSQLDatabaseServer = (CSSOdbcDriver*) m_pCSQLObject;
	
	// allocate a statement handle
	ReturnCode = SQLAllocHandle (SQL_HANDLE_STMT, pSQLDatabaseServer->GetDatabaseHandle(), &hstmt);
	CHECK_FOR_ERROR (hstmt);

	// set statement attributes
	ReturnCode = SQLSetStmtAttr (hstmt, SQL_ATTR_ROW_BIND_TYPE, (PTR)sizeof(dss_select_03_array[0]), SQL_IS_INTEGER);
	CHECK_FOR_ERROR (hstmt);
	ReturnCode = SQLSetStmtAttr (hstmt, SQL_ATTR_ROW_ARRAY_SIZE, (PTR)NUM_ROWS, SQL_IS_INTEGER);
	CHECK_FOR_ERROR (hstmt);
	ReturnCode = SQLSetStmtAttr (hstmt, SQL_ATTR_ROW_STATUS_PTR, row_status_array, SQL_IS_POINTER);
	CHECK_FOR_ERROR (hstmt);
	
	// prepare the statement	
	ReturnCode = SQLPrepare (hstmt, (UCHAR *)m_szSQL.GetBuffer(0), SQL_NTS);
	m_szSQL.ReleaseBuffer();
	CHECK_FOR_ERROR (hstmt);
	
	// bind output variables
	ReturnCode = SQLBindCol (hstmt, 1, SQL_C_SLONG, &dss_select_03_array[0].max_h_key, sizeof(dss_select_03_array[0].max_h_key), &dss_select_03_indicators_array[0].max_h_key);
	CHECK_FOR_ERROR (hstmt);

	// ==========
	
	// initialize variables
	m_nUnits = 0;

	// start timer
	m_CTimer.SetStartTime();

	// execute the statement
	ReturnCode = SQLExecute (hstmt);
	CHECK_FOR_ERROR_EXECUTE (hstmt);

	// fetch loop
	while (TRUE) {

		// check for user cancel
		if (CancelXact()) {
				m_CTimer.SetEndTime(m_nUnits, m_nBytes);
				ReturnCode = SQLFreeHandle (SQL_HANDLE_STMT, hstmt);
				CHECK_FOR_ERROR (hstmt);
				return FALSE;
		}

		// fetch the data
		ReturnCode = SQLFetchScroll (hstmt, SQL_FETCH_NEXT, IGNORE);
		CHECK_FOR_ERROR_FETCH (hstmt);

		// if no more data, exit loop
		if (ReturnCode == SQL_NO_DATA)
			break;

		// otherwise, count number of rows returned
		for (iRowLoop = 0; row_status_array[iRowLoop] != SQL_ROW_NOROW && iRowLoop < NUM_ROWS; iRowLoop++) {
			m_nUnits++;
		}

		// if this is the first time through, record response time
		if (m_nUnits <= NUM_ROWS)
			m_CTimer.SetResponseTime();

		// output data to log if requested
		if (OutputResults())
			for (iRowLoop = 0; row_status_array[iRowLoop] != SQL_ROW_NOROW && iRowLoop < NUM_ROWS; iRowLoop++) {
				GetResultsFile() 
					<< dss_select_03_array[iRowLoop].max_h_key << endl;
		}

	}

	// update statistics
	m_nBytes = m_nUnits * sizeof(dss_select_03_array[0]);

	// set end time
	m_CTimer.SetEndTime (m_nUnits, m_nBytes);

	// free handle
	ReturnCode = SQLFreeHandle (SQL_HANDLE_STMT, hstmt);
	CHECK_FOR_ERROR (hstmt);

	// return
	return TRUE;

}

// ================================================================================

// CXact_DSS_Select_04

CXact_DSS_Select_04::CXact_DSS_Select_04 (void)
{
	m_szName		= "DSS Select 04";
	m_szDescription = "select count(t_key) from tenpct where t_name = 'THE+ASAP+BENCHMARKS+' and t_int <= 100000000 and t_signed between 1 and 99999999 and not (t_float between -450000000 and 450000000) and t_double > 600000000 and t_decim < -600000000";
	m_szSQL			= "select count(t_key) from tenpct where t_name = 'THE+ASAP+BENCHMARKS+' and t_int <= 100000000 and t_signed between 1 and 99999999 and not (t_float between -450000000 and 450000000) and t_double > 600000000 and t_decim < -600000000";
	m_nXactType		= TRANSACTION;
	m_nXID			= XID_DSS_SELECT+04;
	m_nGID			= DSSSelect;
}

CXact_DSS_Select_04::~CXact_DSS_Select_04 (void)
{
}

BOOL CXact_DSS_Select_04::PreBenchmark (void)
{
	return TRUE;
}

BOOL CXact_DSS_Select_04::PostBenchmark (void)
{
	return TRUE;
}

BOOL CXact_DSS_Select_04::Execute (void)
{

	// declare variables
	CSSOdbcDriver *pSQLDatabaseServer;
	SQLHSTMT hstmt;
	int iRowLoop;
	int ReturnCode;
	struct DSS_SELECT_04 {
		SQLINTEGER count_t_key;
	};
	typedef struct DSS_SELECT_04 DSS_SELECT_04;
	struct DSS_SELECT_04_INDICATORS {
		SQLINTEGER count_t_key;
	};
	typedef struct DSS_SELECT_04_INDICATORS DSS_SELECT_04_INDICATORS;
	DSS_SELECT_04 dss_select_04_array[NUM_ROWS];
	DSS_SELECT_04_INDICATORS dss_select_04_indicators_array[NUM_ROWS];
	SQLUSMALLINT row_status_array[NUM_ROWS];

	// initialize variables
	pSQLDatabaseServer = (CSSOdbcDriver*) m_pCSQLObject;
	
	// allocate a statement handle
	ReturnCode = SQLAllocHandle (SQL_HANDLE_STMT, pSQLDatabaseServer->GetDatabaseHandle(), &hstmt);
	CHECK_FOR_ERROR (hstmt);

	// set statement attributes
	ReturnCode = SQLSetStmtAttr (hstmt, SQL_ATTR_ROW_BIND_TYPE, (PTR)sizeof(dss_select_04_array[0]), SQL_IS_INTEGER);
	CHECK_FOR_ERROR (hstmt);
	ReturnCode = SQLSetStmtAttr (hstmt, SQL_ATTR_ROW_ARRAY_SIZE, (PTR)NUM_ROWS, SQL_IS_INTEGER);
	CHECK_FOR_ERROR (hstmt);
	ReturnCode = SQLSetStmtAttr (hstmt, SQL_ATTR_ROW_STATUS_PTR, row_status_array, SQL_IS_POINTER);
	CHECK_FOR_ERROR (hstmt);
	
	// prepare the statement	
	ReturnCode = SQLPrepare (hstmt, (UCHAR *)m_szSQL.GetBuffer(0), SQL_NTS);
	m_szSQL.ReleaseBuffer();
	CHECK_FOR_ERROR (hstmt);
	
	// bind output variables
	ReturnCode = SQLBindCol (hstmt, 1, SQL_C_SLONG, &dss_select_04_array[0].count_t_key, sizeof(dss_select_04_array[0].count_t_key), &dss_select_04_indicators_array[0].count_t_key);
	CHECK_FOR_ERROR (hstmt);

	// ==========
	
	// initialize variables
	m_nUnits = 0;

	// start timer
	m_CTimer.SetStartTime();

	// execute the statement
	ReturnCode = SQLExecute (hstmt);
	CHECK_FOR_ERROR_EXECUTE (hstmt);

	// fetch loop
	while (TRUE) {

		// check for user cancel
		if (CancelXact()) {
				m_CTimer.SetEndTime(m_nUnits, m_nBytes);
				ReturnCode = SQLFreeHandle (SQL_HANDLE_STMT, hstmt);
				CHECK_FOR_ERROR (hstmt);
				return FALSE;
		}

		// fetch the data
		ReturnCode = SQLFetchScroll (hstmt, SQL_FETCH_NEXT, IGNORE);
		CHECK_FOR_ERROR_FETCH (hstmt);

		// if no more data, exit loop
		if (ReturnCode == SQL_NO_DATA)
			break;

		// otherwise, count number of rows returned
		for (iRowLoop = 0; row_status_array[iRowLoop] != SQL_ROW_NOROW && iRowLoop < NUM_ROWS; iRowLoop++) {
			m_nUnits++;
		}

		// if this is the first time through, record response time
		if (m_nUnits <= NUM_ROWS)
			m_CTimer.SetResponseTime();

		// output data to log if requested
		if (OutputResults())
			for (iRowLoop = 0; row_status_array[iRowLoop] != SQL_ROW_NOROW && iRowLoop < NUM_ROWS; iRowLoop++) {
				GetResultsFile() 
					<< dss_select_04_array[iRowLoop].count_t_key << endl;
		}

	}

	// update statistics
	m_nBytes = m_nUnits * sizeof(dss_select_04_array[0]);

	// set end time
	m_CTimer.SetEndTime (m_nUnits, m_nBytes);

	// free handle
	ReturnCode = SQLFreeHandle (SQL_HANDLE_STMT, hstmt);
	CHECK_FOR_ERROR (hstmt);

	// return
	return TRUE;

}

// ================================================================================

// CXact_DSS_Select_05

CXact_DSS_Select_05::CXact_DSS_Select_05 (void)
{
	m_szName		= "DSS Select 05";
	m_szDescription = "select avg(updates.p_decim) from updates where updates.p_key in (select updates.p_key from updates, hundred where hundred.h_key = updates.p_key and updates.p_decim > 990000000)";
	m_szSQL			= "select avg(updates.p_decim) from updates where updates.p_key in (select updates.p_key from updates, hundred where hundred.h_key = updates.p_key and updates.p_decim > 990000000)";
	m_nXactType		= TRANSACTION;
	m_nXID			= XID_DSS_SELECT+05;
	m_nGID			= DSSSelect;
}

CXact_DSS_Select_05::~CXact_DSS_Select_05 (void)
{
}

BOOL CXact_DSS_Select_05::PreBenchmark (void)
{
	return TRUE;
}

BOOL CXact_DSS_Select_05::PostBenchmark (void)
{
	return TRUE;
}

BOOL CXact_DSS_Select_05::Execute (void)
{

	// declare variables
	CSSOdbcDriver *pSQLDatabaseServer;
	SQLHSTMT hstmt;
	int iRowLoop;
	int ReturnCode;
	struct DSS_SELECT_05 {
		SQLREAL average_p_decim;
	};
	typedef struct DSS_SELECT_05 DSS_SELECT_05;
	struct DSS_SELECT_05_INDICATORS {
		SQLINTEGER average_p_decim;
	};
	typedef struct DSS_SELECT_05_INDICATORS DSS_SELECT_05_INDICATORS;
	DSS_SELECT_05 dss_select_05_array[NUM_ROWS];
	DSS_SELECT_05_INDICATORS dss_select_05_indicators_array[NUM_ROWS];
	SQLUSMALLINT row_status_array[NUM_ROWS];

	// initialize variables
	pSQLDatabaseServer = (CSSOdbcDriver*) m_pCSQLObject;

	// allocate a statement handle
	ReturnCode = SQLAllocHandle (SQL_HANDLE_STMT, pSQLDatabaseServer->GetDatabaseHandle(), &hstmt);
	CHECK_FOR_ERROR (hstmt);

	// set statement attributes
	ReturnCode = SQLSetStmtAttr (hstmt, SQL_ATTR_ROW_BIND_TYPE, (PTR)sizeof(dss_select_05_array[0]), SQL_IS_INTEGER);
	CHECK_FOR_ERROR (hstmt);
	ReturnCode = SQLSetStmtAttr (hstmt, SQL_ATTR_ROW_ARRAY_SIZE, (PTR)NUM_ROWS, SQL_IS_INTEGER);
	CHECK_FOR_ERROR (hstmt);
	ReturnCode = SQLSetStmtAttr (hstmt, SQL_ATTR_ROW_STATUS_PTR, row_status_array, SQL_IS_POINTER);
	CHECK_FOR_ERROR (hstmt);
	
	// prepare the statement	
	ReturnCode = SQLPrepare (hstmt, (UCHAR *)m_szSQL.GetBuffer(0), SQL_NTS);
	m_szSQL.ReleaseBuffer();
	CHECK_FOR_ERROR (hstmt);
	
	// bind output variables
	ReturnCode = SQLBindCol (hstmt, 1, SQL_C_FLOAT, &dss_select_05_array[0].average_p_decim, sizeof(dss_select_05_array[0].average_p_decim), &dss_select_05_indicators_array[0].average_p_decim);
	CHECK_FOR_ERROR (hstmt);

	// ==========
	
	// initialize variables
	m_nUnits = 0;

	// start timer
	m_CTimer.SetStartTime();

	// execute the statement
	ReturnCode = SQLExecute (hstmt);
	CHECK_FOR_ERROR_EXECUTE (hstmt);

	// fetch loop
	while (TRUE) {

		// check for user cancel
		if (CancelXact()) {
				m_CTimer.SetEndTime(m_nUnits, m_nBytes);
				ReturnCode = SQLFreeHandle (SQL_HANDLE_STMT, hstmt);
				CHECK_FOR_ERROR (hstmt);
				return FALSE;
		}

		// fetch the data
		ReturnCode = SQLFetchScroll (hstmt, SQL_FETCH_NEXT, IGNORE);
		CHECK_FOR_ERROR_FETCH (hstmt);

		// if no more data, exit loop
		if (ReturnCode == SQL_NO_DATA)
			break;

		// otherwise, count number of rows returned
		for (iRowLoop = 0; row_status_array[iRowLoop] != SQL_ROW_NOROW && iRowLoop < NUM_ROWS; iRowLoop++) {
			m_nUnits++;
		}

		// if this is the first time through, record response time
		if (m_nUnits <= NUM_ROWS)
			m_CTimer.SetResponseTime();

		// output data to log if requested
		if (OutputResults())
			for (iRowLoop = 0; row_status_array[iRowLoop] != SQL_ROW_NOROW && iRowLoop < NUM_ROWS; iRowLoop++) {
				GetResultsFile() 
					<< dss_select_05_array[iRowLoop].average_p_decim << endl;
		}

	}

	// update statistics
	m_nBytes = m_nUnits * sizeof(dss_select_05_array[0]);

	// set end time
	m_CTimer.SetEndTime (m_nUnits, m_nBytes);

	// free handle
	ReturnCode = SQLFreeHandle (SQL_HANDLE_STMT, hstmt);
	CHECK_FOR_ERROR (hstmt);

	// return
	return TRUE;

}

// ================================================================================

// CXact_DSS_Select_06

CXact_DSS_Select_06::CXact_DSS_Select_06 (void)
{
	m_szName		= "DSS Select 06";
#if (_USE_VIEWS == TRUE && _USE_DISTINCT_ == TRUE)
	m_szDescription = "select avg(r_signed), min(r_signed), max(r_signed), min(r_date), max(r_date), count(distinct r_name), count(r_name) from reportview where r_decim > 980000000 group by r_code, r_int order by 1";
	m_szSQL			= "select avg(r_signed), min(r_signed), max(r_signed), min(r_date), max(r_date), count(distinct r_name), count(r_name) from reportview where r_decim > 980000000 group by r_code, r_int order by 1";
#elif (_USE_VIEWS == TRUE && _USE_DISTINCT_ == FALSE)
	m_szDescription = "select avg(r_signed), min(r_signed), max(r_signed), min(r_date), max(r_date), count(r_name), count(r_name) from reportview where r_decim > 980000000 group by r_code, r_int order by 1";
	m_szSQL			= "select avg(r_signed), min(r_signed), max(r_signed), min(r_date), max(r_date), count(r_name), count(r_name) from reportview where r_decim > 980000000 group by r_code, r_int order by 1";
#elif (_USE_VIEWS == FALSE && _USE_DISTINCT_ == TRUE)
	m_szDescription = "select avg(updates.p_signed), min(updates.p_signed), max(updates.p_signed), min(updates.p_date), max(updates.p_date), count(distinct hundred.h_name), count(hundred.h_name) from updates, hundred where updates.p_key = hundred.h_key and updates.p_decim > 980000000 group by hundred.h_code, hundred.h_int order by 1";
	m_szSQL			= "select avg(updates.p_signed), min(updates.p_signed), max(updates.p_signed), min(updates.p_date), max(updates.p_date), count(distinct hundred.h_name), count(hundred.h_name) from updates, hundred where updates.p_key = hundred.h_key and updates.p_decim > 980000000 group by hundred.h_code, hundred.h_int order by 1";
#elif (_USE_VIEWS == FALSE && _USE_DISTINCT_ == FALSE)
	m_szDescription = "select avg(updates.p_signed), min(updates.p_signed), max(updates.p_signed), min(updates.p_date), max(updates.p_date), count(hundred.h_name), count(hundred.h_name) from updates, hundred where updates.p_key = hundred.h_key and updates.p_decim > 980000000 group by hundred.h_code, hundred.h_int order by 1";
	m_szSQL			= "select avg(updates.p_signed), min(updates.p_signed), max(updates.p_signed), min(updates.p_date), max(updates.p_date), count(hundred.h_name), count(hundred.h_name) from updates, hundred where updates.p_key = hundred.h_key and updates.p_decim > 980000000 group by hundred.h_code, hundred.h_int order by 1";
#endif
	m_nXactType		= TRANSACTION;
	m_nXID			= XID_DSS_SELECT+06;
	m_nGID			= DSSSelect;
}

CXact_DSS_Select_06::~CXact_DSS_Select_06 (void)
{
}

BOOL CXact_DSS_Select_06::PreBenchmark (void)
{
	return TRUE;
}

BOOL CXact_DSS_Select_06::PostBenchmark (void)
{
	return TRUE;
}

BOOL CXact_DSS_Select_06::Execute (void)
{

	// declare variables
	CSSOdbcDriver *pSQLDatabaseServer;
	SQLHSTMT hstmt;
	int iRowLoop;
	int ReturnCode;
	struct DSS_SELECT_06 {
		SQLREAL average_r_signed;
		SQLINTEGER min_r_signed;
		SQLINTEGER max_r_signed;
		SQLCHAR min_r_date[35];
		SQLCHAR max_r_date[35];
		SQLINTEGER count_distinct_r_name;
		SQLINTEGER count_r_name;
	};
	typedef struct DSS_SELECT_06 DSS_SELECT_06;
	struct DSS_SELECT_06_INDICATORS {
		SQLINTEGER average_r_signed;
		SQLINTEGER min_r_signed;
		SQLINTEGER max_r_signed;
		SQLINTEGER min_r_date;
		SQLINTEGER max_r_date;
		SQLINTEGER count_distinct_r_name;
		SQLINTEGER count_r_name;
	};
	typedef struct DSS_SELECT_06_INDICATORS DSS_SELECT_06_INDICATORS;
	DSS_SELECT_06 dss_select_06_array[NUM_ROWS];
	DSS_SELECT_06_INDICATORS dss_select_06_indicators_array[NUM_ROWS];
	SQLUSMALLINT row_status_array[NUM_ROWS];

	// initialize variables
	pSQLDatabaseServer = (CSSOdbcDriver*) m_pCSQLObject;

	// allocate a statement handle
	ReturnCode = SQLAllocHandle (SQL_HANDLE_STMT, pSQLDatabaseServer->GetDatabaseHandle(), &hstmt);
	CHECK_FOR_ERROR (hstmt);

	// set statement attributes
	ReturnCode = SQLSetStmtAttr (hstmt, SQL_ATTR_ROW_BIND_TYPE, (PTR)sizeof(dss_select_06_array[0]), SQL_IS_INTEGER);
	CHECK_FOR_ERROR (hstmt);
	ReturnCode = SQLSetStmtAttr (hstmt, SQL_ATTR_ROW_ARRAY_SIZE, (PTR)NUM_ROWS, SQL_IS_INTEGER);
	CHECK_FOR_ERROR (hstmt);
	ReturnCode = SQLSetStmtAttr (hstmt, SQL_ATTR_ROW_STATUS_PTR, row_status_array, SQL_IS_POINTER);
	CHECK_FOR_ERROR (hstmt);
	
	// prepare the statement	
	ReturnCode = SQLPrepare (hstmt, (UCHAR *)m_szSQL.GetBuffer(0), SQL_NTS);
	m_szSQL.ReleaseBuffer();
	CHECK_FOR_ERROR (hstmt);
	
	// bind output variables
	ReturnCode = SQLBindCol (hstmt, 1, SQL_C_FLOAT, &dss_select_06_array[0].average_r_signed, sizeof(dss_select_06_array[0].average_r_signed), &dss_select_06_indicators_array[0].average_r_signed);
	CHECK_FOR_ERROR (hstmt);
	ReturnCode = SQLBindCol (hstmt, 2, SQL_C_SLONG, &dss_select_06_array[0].min_r_signed, sizeof(dss_select_06_array[0].min_r_signed), &dss_select_06_indicators_array[0].min_r_signed);
	CHECK_FOR_ERROR (hstmt);
	ReturnCode = SQLBindCol (hstmt, 3, SQL_C_SLONG, &dss_select_06_array[0].max_r_signed, sizeof(dss_select_06_array[0].max_r_signed), &dss_select_06_indicators_array[0].max_r_signed);
	CHECK_FOR_ERROR (hstmt);
	ReturnCode = SQLBindCol (hstmt, 4, SQL_C_CHAR, dss_select_06_array[0].min_r_date, sizeof(dss_select_06_array[0].min_r_date), &dss_select_06_indicators_array[0].min_r_date);
	CHECK_FOR_ERROR (hstmt);
	ReturnCode = SQLBindCol (hstmt, 5, SQL_C_CHAR, dss_select_06_array[0].max_r_date, sizeof(dss_select_06_array[0].max_r_date), &dss_select_06_indicators_array[0].max_r_date);
	CHECK_FOR_ERROR (hstmt);
	ReturnCode = SQLBindCol (hstmt, 6, SQL_C_SLONG, &dss_select_06_array[0].count_distinct_r_name, sizeof(dss_select_06_array[0].count_distinct_r_name), &dss_select_06_indicators_array[0].count_distinct_r_name);
	CHECK_FOR_ERROR (hstmt);
	ReturnCode = SQLBindCol (hstmt, 7, SQL_C_SLONG, &dss_select_06_array[0].count_r_name, sizeof(dss_select_06_array[0].count_r_name), &dss_select_06_indicators_array[0].count_r_name);
	CHECK_FOR_ERROR (hstmt);

	// ==========
	
	// initialize variables
	m_nUnits = 0;

	// start timer
	m_CTimer.SetStartTime();

	// execute the statement
	ReturnCode = SQLExecute (hstmt);
	CHECK_FOR_ERROR_EXECUTE (hstmt);

	// fetch loop
	while (TRUE) {

		// check for user cancel
		if (CancelXact()) {
				m_CTimer.SetEndTime(m_nUnits, m_nBytes);
				ReturnCode = SQLFreeHandle (SQL_HANDLE_STMT, hstmt);
				CHECK_FOR_ERROR (hstmt);
				return FALSE;
		}

		// fetch the data
		ReturnCode = SQLFetchScroll (hstmt, SQL_FETCH_NEXT, IGNORE);
		CHECK_FOR_ERROR_FETCH (hstmt);

		// if no more data, exit loop
		if (ReturnCode == SQL_NO_DATA)
			break;

		// otherwise, count number of rows returned
		for (iRowLoop = 0; row_status_array[iRowLoop] != SQL_ROW_NOROW && iRowLoop < NUM_ROWS; iRowLoop++) {
			m_nUnits++;
		}

		// if this is the first time through, record response time
		if (m_nUnits <= NUM_ROWS)
			m_CTimer.SetResponseTime();

		// output data to log if requested
		if (OutputResults())
			for (iRowLoop = 0; row_status_array[iRowLoop] != SQL_ROW_NOROW && iRowLoop < NUM_ROWS; iRowLoop++) {
				GetResultsFile() 
					<< dss_select_06_array[iRowLoop].average_r_signed << tab
					<< dss_select_06_array[iRowLoop].min_r_signed << tab
					<< dss_select_06_array[iRowLoop].max_r_signed << tab
					<< dss_select_06_array[iRowLoop].min_r_date << tab
					<< dss_select_06_array[iRowLoop].max_r_date << tab
					<< dss_select_06_array[iRowLoop].count_distinct_r_name << tab
					<< dss_select_06_array[iRowLoop].count_r_name << endl;
			}

	}

	// update statistics
	m_nBytes = m_nUnits * sizeof(dss_select_06_array[0]);

	// set end time
	m_CTimer.SetEndTime (m_nUnits, m_nBytes);

	// free handle
	ReturnCode = SQLFreeHandle (SQL_HANDLE_STMT, hstmt);
	CHECK_FOR_ERROR (hstmt);

	// return
	return TRUE;

}

// ================================================================================

// CXact_DSS_Select_07

CXact_DSS_Select_07::CXact_DSS_Select_07 (void)
{
	m_szName		= "DSS Select 07";
#if (_USE_VIEWS == TRUE && _USE_DISTINCT_ == TRUE)
	m_szDescription = "select min(r_signed), max(r_signed), min(r_date), max(r_date), count(distinct r_name), count(r_name), count(r_code), count(r_int) from reportview where r_decim > 900000000";
	m_szSQL			= "select min(r_signed), max(r_signed), min(r_date), max(r_date), count(distinct r_name), count(r_name), count(r_code), count(r_int) from reportview where r_decim > 900000000";
#elif (_USE_VIEWS == TRUE && _USE_DISTINCT_ == FALSE)
	m_szDescription = "select min(r_signed), max(r_signed), min(r_date), max(r_date), count(r_name), count(r_name), count(r_code), count(r_int) from reportview where r_decim > 900000000";
	m_szSQL			= "select min(r_signed), max(r_signed), min(r_date), max(r_date), count(r_name), count(r_name), count(r_code), count(r_int) from reportview where r_decim > 900000000";
#elif (_USE_VIEWS == FALSE && _USE_DISTINCT_ == TRUE)
	m_szDescription = "select min(updates.p_signed), max(updates.p_signed), min(updates.p_date), max(updates.p_date), count(distinct hundred.h_name), count(hundred.h_name), count(hundred.h_code), count(hundred.h_int) from updates, hundred where updates.p_key = hundred.h_key and updates.p_decim > 900000000";
	m_szSQL			= "select min(updates.p_signed), max(updates.p_signed), min(updates.p_date), max(updates.p_date), count(distinct hundred.h_name), count(hundred.h_name), count(hundred.h_code), count(hundred.h_int) from updates, hundred where updates.p_key = hundred.h_key and updates.p_decim > 900000000";
#elif (_USE_VIEWS == FALSE && _USE_DISTINCT_ == FALSE)
	m_szDescription = "select min(updates.p_signed), max(updates.p_signed), min(updates.p_date), max(updates.p_date), count(hundred.h_name), count(hundred.h_name), count(hundred.h_code), count(hundred.h_int) from updates, hundred where updates.p_key = hundred.h_key and updates.p_decim > 900000000";
	m_szSQL			= "select min(updates.p_signed), max(updates.p_signed), min(updates.p_date), max(updates.p_date), count(hundred.h_name), count(hundred.h_name), count(hundred.h_code), count(hundred.h_int) from updates, hundred where updates.p_key = hundred.h_key and updates.p_decim > 900000000";
#endif
	m_nXactType		= TRANSACTION;
	m_nXID			= XID_DSS_SELECT+7;
	m_nGID			= DSSSelect;
}

CXact_DSS_Select_07::~CXact_DSS_Select_07 (void)
{
}

BOOL CXact_DSS_Select_07::PreBenchmark (void)
{
	return TRUE;
}

BOOL CXact_DSS_Select_07::PostBenchmark (void)
{
	return TRUE;
}

BOOL CXact_DSS_Select_07::Execute (void)
{

	// declare variables
	CSSOdbcDriver *pSQLDatabaseServer;
	SQLHSTMT hstmt;
	int iRowLoop;
	int ReturnCode;
	struct DSS_SELECT_07 {
		SQLINTEGER min_r_signed;
		SQLINTEGER max_r_signed;
		SQLCHAR min_r_date[35];
		SQLCHAR max_r_date[35];
		SQLINTEGER count_distinct_r_name;
		SQLINTEGER count_r_name;
		SQLINTEGER count_r_code;
		SQLINTEGER count_r_int;
	};
	typedef struct DSS_SELECT_07 DSS_SELECT_07;
	struct DSS_SELECT_07_INDICATORS {
		SQLINTEGER min_r_signed;
		SQLINTEGER max_r_signed;
		SQLINTEGER min_r_date;
		SQLINTEGER max_r_date;
		SQLINTEGER count_distinct_r_name;
		SQLINTEGER count_r_name;
		SQLINTEGER count_r_code;
		SQLINTEGER count_r_int;
	};
	typedef struct DSS_SELECT_07_INDICATORS DSS_SELECT_07_INDICATORS;
	DSS_SELECT_07 dss_select_07_array[NUM_ROWS];
	DSS_SELECT_07_INDICATORS dss_select_07_indicators_array[NUM_ROWS];
	SQLUSMALLINT row_status_array[NUM_ROWS];

	// initialize variables
	pSQLDatabaseServer = (CSSOdbcDriver*) m_pCSQLObject;

	// allocate a statement handle
	ReturnCode = SQLAllocHandle (SQL_HANDLE_STMT, pSQLDatabaseServer->GetDatabaseHandle(), &hstmt);
	CHECK_FOR_ERROR (hstmt);

	// set statement attributes
	ReturnCode = SQLSetStmtAttr (hstmt, SQL_ATTR_ROW_BIND_TYPE, (PTR)sizeof(dss_select_07_array[0]), SQL_IS_INTEGER);
	CHECK_FOR_ERROR (hstmt);
	ReturnCode = SQLSetStmtAttr (hstmt, SQL_ATTR_ROW_ARRAY_SIZE, (PTR)NUM_ROWS, SQL_IS_INTEGER);
	CHECK_FOR_ERROR (hstmt);
	ReturnCode = SQLSetStmtAttr (hstmt, SQL_ATTR_ROW_STATUS_PTR, row_status_array, SQL_IS_POINTER);
	CHECK_FOR_ERROR (hstmt);

	// prepare the statement	
	ReturnCode = SQLPrepare (hstmt, (UCHAR *)m_szSQL.GetBuffer(0), SQL_NTS);
	m_szSQL.ReleaseBuffer();
	CHECK_FOR_ERROR (hstmt);
	
	// bind output variables
	ReturnCode = SQLBindCol (hstmt, 1, SQL_C_SLONG, &dss_select_07_array[0].min_r_signed, sizeof(dss_select_07_array[0].min_r_signed), &dss_select_07_indicators_array[0].min_r_signed);
	CHECK_FOR_ERROR (hstmt);
	ReturnCode = SQLBindCol (hstmt, 2, SQL_C_SLONG, &dss_select_07_array[0].max_r_signed, sizeof(dss_select_07_array[0].max_r_signed), &dss_select_07_indicators_array[0].max_r_signed);
	CHECK_FOR_ERROR (hstmt);
	ReturnCode = SQLBindCol (hstmt, 3, SQL_C_CHAR, dss_select_07_array[0].min_r_date, sizeof(dss_select_07_array[0].min_r_date), &dss_select_07_indicators_array[0].min_r_date);
	CHECK_FOR_ERROR (hstmt);
	ReturnCode = SQLBindCol (hstmt, 4, SQL_C_CHAR, dss_select_07_array[0].max_r_date, sizeof(dss_select_07_array[0].max_r_date), &dss_select_07_indicators_array[0].max_r_date);
	CHECK_FOR_ERROR (hstmt);
	ReturnCode = SQLBindCol (hstmt, 5, SQL_C_SLONG, &dss_select_07_array[0].count_distinct_r_name, sizeof(dss_select_07_array[0].count_distinct_r_name), &dss_select_07_indicators_array[0].count_distinct_r_name);
	CHECK_FOR_ERROR (hstmt);
	ReturnCode = SQLBindCol (hstmt, 6, SQL_C_SLONG, &dss_select_07_array[0].count_r_name, sizeof(dss_select_07_array[0].count_r_name), &dss_select_07_indicators_array[0].count_r_name);
	CHECK_FOR_ERROR (hstmt);
	ReturnCode = SQLBindCol (hstmt, 7, SQL_C_SLONG, &dss_select_07_array[0].count_r_code, sizeof(dss_select_07_array[0].count_r_code), &dss_select_07_indicators_array[0].count_r_code);
	CHECK_FOR_ERROR (hstmt);
	ReturnCode = SQLBindCol (hstmt, 8, SQL_C_SLONG, &dss_select_07_array[0].count_r_int, sizeof(dss_select_07_array[0].count_r_int), &dss_select_07_indicators_array[0].count_r_int);
	CHECK_FOR_ERROR (hstmt);

	// ==========
	
	// initialize variables
	m_nUnits = 0;

	// start timer
	m_CTimer.SetStartTime();

	// execute the statement
	ReturnCode = SQLExecute (hstmt);
	CHECK_FOR_ERROR_EXECUTE (hstmt);

	// fetch loop
	while (TRUE) {

		// check for user cancel
		if (CancelXact()) {
				m_CTimer.SetEndTime(m_nUnits, m_nBytes);
				ReturnCode = SQLFreeHandle (SQL_HANDLE_STMT, hstmt);
				CHECK_FOR_ERROR (hstmt);
				return FALSE;
		}

		// fetch the data
		ReturnCode = SQLFetchScroll (hstmt, SQL_FETCH_NEXT, IGNORE);
		CHECK_FOR_ERROR_FETCH (hstmt);

		// if no more data, exit loop
		if (ReturnCode == SQL_NO_DATA)
			break;

		// otherwise, count number of rows returned
		for (iRowLoop = 0; row_status_array[iRowLoop] != SQL_ROW_NOROW && iRowLoop < NUM_ROWS; iRowLoop++) {
			m_nUnits++;
		}

		// if this is the first time through, record response time
		if (m_nUnits <= NUM_ROWS)
			m_CTimer.SetResponseTime();

		// output data to log if requested
		if (OutputResults())
			for (iRowLoop = 0; row_status_array[iRowLoop] != SQL_ROW_NOROW && iRowLoop < NUM_ROWS; iRowLoop++) {
				GetResultsFile() 
					<< dss_select_07_array[iRowLoop].min_r_signed << tab
					<< dss_select_07_array[iRowLoop].max_r_signed << tab
					<< dss_select_07_array[iRowLoop].min_r_date << tab
					<< dss_select_07_array[iRowLoop].max_r_date << tab
					<< dss_select_07_array[iRowLoop].count_distinct_r_name << tab
					<< dss_select_07_array[iRowLoop].count_r_name << tab
					<< dss_select_07_array[iRowLoop].count_r_code << tab
					<< dss_select_07_array[iRowLoop].count_r_int << endl;
			}

	}

	// update statistics
	m_nBytes = m_nUnits * sizeof(dss_select_07_array[0]);

	// set end time
	m_CTimer.SetEndTime (m_nUnits, m_nBytes);

	// free handle
	ReturnCode = SQLFreeHandle (SQL_HANDLE_STMT, hstmt);
	CHECK_FOR_ERROR (hstmt);

	// return
	return TRUE;

}

// ================================================================================

// CXact_DSS_Select_08

CXact_DSS_Select_08::CXact_DSS_Select_08 (void)
{
	m_szName		= "DSS Select 08";
	m_szDescription = "select h_name, count(h_name) from hundred group by h_name order by 2";
	m_szSQL			= "select h_name, count(h_name) from hundred group by h_name order by 2";
	m_nXactType		= TRANSACTION;
	m_nXID			= XID_DSS_SELECT+8;
	m_nGID			= DSSSelect;
}

CXact_DSS_Select_08::~CXact_DSS_Select_08 (void)
{
}

BOOL CXact_DSS_Select_08::PreBenchmark (void)
{
	return TRUE;
}

BOOL CXact_DSS_Select_08::PostBenchmark (void)
{
	return TRUE;
}

BOOL CXact_DSS_Select_08::Execute (void)
{

	// declare variables
	CSSOdbcDriver *pSQLDatabaseServer;
	SQLHSTMT hstmt;
	int iRowLoop;
	int ReturnCode;
	struct DSS_SELECT_08 {
		SQLCHAR h_name[25];
		SQLINTEGER count_h_name;
	};
	typedef struct DSS_SELECT_08 DSS_SELECT_08;
	struct DSS_SELECT_08_INDICATORS {
		SQLINTEGER h_name;
		SQLINTEGER count_h_name;
	};
	typedef struct DSS_SELECT_08_INDICATORS DSS_SELECT_08_INDICATORS;
	DSS_SELECT_08 dss_select_08_array[NUM_ROWS];
	DSS_SELECT_08_INDICATORS dss_select_08_indicators_array[NUM_ROWS];
	SQLUSMALLINT row_status_array[NUM_ROWS];

	// initialize variables
	pSQLDatabaseServer = (CSSOdbcDriver*) m_pCSQLObject;
	
	// allocate a statement handle
	ReturnCode = SQLAllocHandle (SQL_HANDLE_STMT, pSQLDatabaseServer->GetDatabaseHandle(), &hstmt);
	CHECK_FOR_ERROR (hstmt);

	// set statement attributes
	ReturnCode = SQLSetStmtAttr (hstmt, SQL_ATTR_ROW_BIND_TYPE, (PTR)sizeof(dss_select_08_array[0]), SQL_IS_INTEGER);
	CHECK_FOR_ERROR (hstmt);
	ReturnCode = SQLSetStmtAttr (hstmt, SQL_ATTR_ROW_ARRAY_SIZE, (PTR)NUM_ROWS, SQL_IS_INTEGER);
	CHECK_FOR_ERROR (hstmt);
	ReturnCode = SQLSetStmtAttr (hstmt, SQL_ATTR_ROW_STATUS_PTR, row_status_array, SQL_IS_POINTER);
	CHECK_FOR_ERROR (hstmt);

	// prepare the statement	
	ReturnCode = SQLPrepare (hstmt, (UCHAR *)m_szSQL.GetBuffer(0), SQL_NTS);
	m_szSQL.ReleaseBuffer();
	CHECK_FOR_ERROR (hstmt);
	
	// bind output variables
	ReturnCode = SQLBindCol (hstmt, 1, SQL_C_CHAR, dss_select_08_array[0].h_name, sizeof(dss_select_08_array[0].h_name), &dss_select_08_indicators_array[0].h_name);
	CHECK_FOR_ERROR (hstmt);
	ReturnCode = SQLBindCol (hstmt, 2, SQL_C_SLONG, &dss_select_08_array[0].count_h_name, sizeof(dss_select_08_array[0].count_h_name), &dss_select_08_indicators_array[0].count_h_name);
	CHECK_FOR_ERROR (hstmt);

	// ==========
	
	// initialize variables
	m_nUnits = 0;
	
	// start timer
	m_CTimer.SetStartTime();

	// execute the statement
	ReturnCode = SQLExecute (hstmt);
	CHECK_FOR_ERROR_EXECUTE (hstmt);

	// fetch loop
	while (TRUE) {

		// check for user cancel
		if (CancelXact()) {
				m_CTimer.SetEndTime(m_nUnits, m_nBytes);
				ReturnCode = SQLFreeHandle (SQL_HANDLE_STMT, hstmt);
				CHECK_FOR_ERROR (hstmt);
				return FALSE;
		}

		// fetch the data
		ReturnCode = SQLFetchScroll (hstmt, SQL_FETCH_NEXT, IGNORE);
		CHECK_FOR_ERROR_FETCH (hstmt);

		// if no more data, exit loop
		if (ReturnCode == SQL_NO_DATA) {
			break;
		}

		// otherwise, count number of rows returned
		for (iRowLoop = 0; row_status_array[iRowLoop] != SQL_ROW_NOROW && iRowLoop < NUM_ROWS; iRowLoop++) {
			m_nUnits++;
		}

		// if this is the first time through, record response time
		if (m_nUnits <= NUM_ROWS) {
			m_CTimer.SetResponseTime();
		}

		// output data to log if requested
		if (OutputResults()) {
			for (iRowLoop = 0; row_status_array[iRowLoop] != SQL_ROW_NOROW && iRowLoop < NUM_ROWS; iRowLoop++) {
				GetResultsFile() 
					<< dss_select_08_array[iRowLoop].h_name << tab
					<< dss_select_08_array[iRowLoop].count_h_name << endl;
			}
		}

	}

	// update statistics
	m_nBytes = m_nUnits * sizeof(dss_select_08_array[0]);

	// set end time
	m_CTimer.SetEndTime (m_nUnits, m_nBytes);

	// free handle
	ReturnCode = SQLFreeHandle (SQL_HANDLE_STMT, hstmt);
	CHECK_FOR_ERROR (hstmt);

	// return
	return TRUE;

}

// ================================================================================

// CXact_DSS_Select_09

CXact_DSS_Select_09::CXact_DSS_Select_09 (void)
{
	m_szName		= "DSS Select 09";
	m_szDescription = "select h_name from hundred group by h_name having count(h_name) > 10 order by h_name";
	m_szSQL			= "select h_name from hundred group by h_name having count(h_name) > 10 order by h_name";
	m_nXactType		= TRANSACTION;
	m_nXID			= XID_DSS_SELECT+9;
	m_nGID			= DSSSelect;
}

CXact_DSS_Select_09::~CXact_DSS_Select_09 (void)
{
}

BOOL CXact_DSS_Select_09::PreBenchmark (void)
{
	return TRUE;
}

BOOL CXact_DSS_Select_09::PostBenchmark (void)
{
	return TRUE;
}

BOOL CXact_DSS_Select_09::Execute (void)
{

	// declare variables
	CSSOdbcDriver *pSQLDatabaseServer;
	SQLHSTMT hstmt;
	int iRowLoop;
	int ReturnCode;
	struct DSS_SELECT_09 {
		SQLCHAR h_name[25];
	};
	typedef struct DSS_SELECT_09 DSS_SELECT_09;
	struct DSS_SELECT_09_INDICATORS {
		SQLINTEGER h_name;
	};
	typedef struct DSS_SELECT_09_INDICATORS DSS_SELECT_09_INDICATORS;
	DSS_SELECT_09 dss_select_09_array[NUM_ROWS];
	DSS_SELECT_09_INDICATORS dss_select_09_indicators_array[NUM_ROWS];
	SQLUSMALLINT row_status_array[NUM_ROWS];

	// initialize variables
	pSQLDatabaseServer = (CSSOdbcDriver*) m_pCSQLObject;
	
	// allocate a statement handle
	ReturnCode = SQLAllocHandle (SQL_HANDLE_STMT, pSQLDatabaseServer->GetDatabaseHandle(), &hstmt);
	CHECK_FOR_ERROR (hstmt);

	// set statement attributes
	ReturnCode = SQLSetStmtAttr (hstmt, SQL_ATTR_ROW_BIND_TYPE, (PTR)sizeof(dss_select_09_array[0]), SQL_IS_INTEGER);
	CHECK_FOR_ERROR (hstmt);
	ReturnCode = SQLSetStmtAttr (hstmt, SQL_ATTR_ROW_ARRAY_SIZE, (PTR)NUM_ROWS, SQL_IS_INTEGER);
	CHECK_FOR_ERROR (hstmt);
	ReturnCode = SQLSetStmtAttr (hstmt, SQL_ATTR_ROW_STATUS_PTR, row_status_array, SQL_IS_POINTER);
	CHECK_FOR_ERROR (hstmt);

	// prepare the statement	
	ReturnCode = SQLPrepare (hstmt, (UCHAR *)m_szSQL.GetBuffer(0), SQL_NTS);
	m_szSQL.ReleaseBuffer();
	CHECK_FOR_ERROR (hstmt);
	
	// bind output variables
	ReturnCode = SQLBindCol (hstmt, 1, SQL_C_CHAR, dss_select_09_array[0].h_name, sizeof(dss_select_09_array[0].h_name), &dss_select_09_indicators_array[0].h_name);
	CHECK_FOR_ERROR (hstmt);

	// ==========
	
	// initialize variables
	m_nUnits = 0;

	// start timer
	m_CTimer.SetStartTime();

	// execute the statement
	ReturnCode = SQLExecute (hstmt);
	CHECK_FOR_ERROR_EXECUTE (hstmt);

	// fetch loop
	while (TRUE) {

		// check for user cancel
		if (CancelXact()) {
				m_CTimer.SetEndTime(m_nUnits, m_nBytes);
				ReturnCode = SQLFreeHandle (SQL_HANDLE_STMT, hstmt);
				CHECK_FOR_ERROR (hstmt);
				return FALSE;
		}

		// fetch the data
		ReturnCode = SQLFetchScroll (hstmt, SQL_FETCH_NEXT, IGNORE);
		CHECK_FOR_ERROR_FETCH (hstmt);

		// if no more data, exit loop
		if (ReturnCode == SQL_NO_DATA)
			break;

		// otherwise, count number of rows returned
		for (iRowLoop = 0; row_status_array[iRowLoop] != SQL_ROW_NOROW && iRowLoop < NUM_ROWS; iRowLoop++) {
			m_nUnits++;
		}

		// if this is the first time through, record response time
		if (m_nUnits <= NUM_ROWS)
			m_CTimer.SetResponseTime();

		// output data to log if requested
		if (OutputResults())
			for (iRowLoop = 0; row_status_array[iRowLoop] != SQL_ROW_NOROW && iRowLoop < NUM_ROWS; iRowLoop++) {
				GetResultsFile() 
					<< dss_select_09_array[iRowLoop].h_name << endl;
		}

	}

	// update statistics
	m_nBytes = m_nUnits * sizeof(dss_select_09_array[0]);

	// set end time
	m_CTimer.SetEndTime (m_nUnits, m_nBytes);

	// free handle
	ReturnCode = SQLFreeHandle (SQL_HANDLE_STMT, hstmt);
	CHECK_FOR_ERROR (hstmt);

	// return
	return TRUE;

}

// ================================================================================

// CXact_DSS_Select_10

CXact_DSS_Select_10::CXact_DSS_Select_10 (void)
{
	m_szName		= "DSS Select 10";
	m_szDescription = "select count(h_name) from hunthou where h_float > (select avg(h_float) from hunthou)";
	m_szSQL			= "select count(h_name) from hunthou where h_float > (select avg(h_float) from hunthou)";
	m_nXactType		= TRANSACTION;
	m_nXID			= XID_DSS_SELECT+10;
	m_nGID			= DSSSelect;
}

CXact_DSS_Select_10::~CXact_DSS_Select_10 (void)
{
}

BOOL CXact_DSS_Select_10::PreBenchmark (void)
{
	return TRUE;
}

BOOL CXact_DSS_Select_10::PostBenchmark (void)
{
	return TRUE;
}

BOOL CXact_DSS_Select_10::Execute (void)
{

	// declare variables
	CSSOdbcDriver *pSQLDatabaseServer;
	SQLHSTMT hstmt;
	int iRowLoop;
	int ReturnCode;
	struct DSS_SELECT_10 {
		SQLINTEGER count_h_name;
	};
	typedef struct DSS_SELECT_10 DSS_SELECT_10;
	struct DSS_SELECT_10_INDICATORS {
		SQLINTEGER count_h_name;
	};
	typedef struct DSS_SELECT_10_INDICATORS DSS_SELECT_10_INDICATORS;
	DSS_SELECT_10 dss_select_10_array[NUM_ROWS];
	DSS_SELECT_10_INDICATORS dss_select_10_indicators_array[NUM_ROWS];
	SQLUSMALLINT row_status_array[NUM_ROWS];

	// initialize variables
	pSQLDatabaseServer = (CSSOdbcDriver*) m_pCSQLObject;
	
	// allocate a statement handle
	ReturnCode = SQLAllocHandle (SQL_HANDLE_STMT, pSQLDatabaseServer->GetDatabaseHandle(), &hstmt);
	CHECK_FOR_ERROR (hstmt);

	// set statement attributes
	ReturnCode = SQLSetStmtAttr (hstmt, SQL_ATTR_ROW_BIND_TYPE, (PTR)sizeof(dss_select_10_array[0]), SQL_IS_INTEGER);
	CHECK_FOR_ERROR (hstmt);
	ReturnCode = SQLSetStmtAttr (hstmt, SQL_ATTR_ROW_ARRAY_SIZE, (PTR)NUM_ROWS, SQL_IS_INTEGER);
	CHECK_FOR_ERROR (hstmt);
	ReturnCode = SQLSetStmtAttr (hstmt, SQL_ATTR_ROW_STATUS_PTR, row_status_array, SQL_IS_POINTER);
	CHECK_FOR_ERROR (hstmt);

	// prepare the statement	
	ReturnCode = SQLPrepare (hstmt, (UCHAR *)m_szSQL.GetBuffer(0), SQL_NTS);
	m_szSQL.ReleaseBuffer();
	CHECK_FOR_ERROR (hstmt);
	
	// bind output variables
	ReturnCode = SQLBindCol (hstmt, 1, SQL_C_SLONG, &dss_select_10_array[0].count_h_name, sizeof(dss_select_10_array[0].count_h_name), &dss_select_10_indicators_array[0].count_h_name);
	CHECK_FOR_ERROR (hstmt);

	// ==========
	
	// initialize variables
	m_nUnits = 0;

	// start timer
	m_CTimer.SetStartTime();

	// execute the statement
	ReturnCode = SQLExecute (hstmt);
	CHECK_FOR_ERROR_EXECUTE (hstmt);

	// fetch loop
	while (TRUE) {

		// check for user cancel
		if (CancelXact()) {
				m_CTimer.SetEndTime(m_nUnits, m_nBytes);
				ReturnCode = SQLFreeHandle (SQL_HANDLE_STMT, hstmt);
				CHECK_FOR_ERROR (hstmt);
				return FALSE;
		}

		// fetch the data
		ReturnCode = SQLFetchScroll (hstmt, SQL_FETCH_NEXT, IGNORE);
		CHECK_FOR_ERROR_FETCH (hstmt);

		// if no more data, exit loop
		if (ReturnCode == SQL_NO_DATA)
			break;

		// otherwise, count number of rows returned
		for (iRowLoop = 0; row_status_array[iRowLoop] != SQL_ROW_NOROW && iRowLoop < NUM_ROWS; iRowLoop++) {
			m_nUnits++;
		}

		// if this is the first time through, record response time
		if (m_nUnits <= NUM_ROWS)
			m_CTimer.SetResponseTime();

		// output data to log if requested
		if (OutputResults())
			for (iRowLoop = 0; row_status_array[iRowLoop] != SQL_ROW_NOROW && iRowLoop < NUM_ROWS; iRowLoop++) {
				GetResultsFile() 
					<< dss_select_10_array[iRowLoop].count_h_name << endl;
		}

	}

	// update statistics
	m_nBytes = m_nUnits * sizeof(dss_select_10_array[0]);

	// set end time
	m_CTimer.SetEndTime (m_nUnits, m_nBytes);

	// free handle
	ReturnCode = SQLFreeHandle (SQL_HANDLE_STMT, hstmt);
	CHECK_FOR_ERROR (hstmt);

	// return
	return TRUE;

}

// ================================================================================

// CXact_DSS_Select_11

CXact_DSS_Select_11::CXact_DSS_Select_11 (void)
{
	m_szName		= "DSS Select 11";
	m_szDescription = "select count(t_key) from threemill where t_signed <= -250000000";
	m_szSQL			= "select count(t_key) from threemill where t_signed <= -250000000";
	m_nXactType		= TRANSACTION;
	m_nXID			= XID_DSS_SELECT+11;
	m_nGID			= DSSSelect;
}

CXact_DSS_Select_11::~CXact_DSS_Select_11 (void)
{
}

BOOL CXact_DSS_Select_11::PreBenchmark (void)
{
	return TRUE;
}

BOOL CXact_DSS_Select_11::PostBenchmark (void)
{
	return TRUE;
}

BOOL CXact_DSS_Select_11::Execute (void)
{

	// declare variables
	CSSOdbcDriver *pSQLDatabaseServer;
	SQLHSTMT hstmt;
	int iRowLoop;
	int ReturnCode;
	struct DSS_SELECT_11 {
		SQLINTEGER count_t_key;
	};
	typedef struct DSS_SELECT_11 DSS_SELECT_11;
	struct DSS_SELECT_11_INDICATORS {
		SQLINTEGER count_t_key;
	};
	typedef struct DSS_SELECT_11_INDICATORS DSS_SELECT_11_INDICATORS;
	DSS_SELECT_11 dss_select_11_array[NUM_ROWS];
	DSS_SELECT_11_INDICATORS dss_select_11_indicators_array[NUM_ROWS];
	SQLUSMALLINT row_status_array[NUM_ROWS];

	// initialize variables
	pSQLDatabaseServer = (CSSOdbcDriver*) m_pCSQLObject;
	
	// allocate a statement handle
	ReturnCode = SQLAllocHandle (SQL_HANDLE_STMT, pSQLDatabaseServer->GetDatabaseHandle(), &hstmt);
	CHECK_FOR_ERROR (hstmt);

	// set statement attributes
	ReturnCode = SQLSetStmtAttr (hstmt, SQL_ATTR_ROW_BIND_TYPE, (PTR)sizeof(dss_select_11_array[0]), SQL_IS_INTEGER);
	CHECK_FOR_ERROR (hstmt);
	ReturnCode = SQLSetStmtAttr (hstmt, SQL_ATTR_ROW_ARRAY_SIZE, (PTR)NUM_ROWS, SQL_IS_INTEGER);
	CHECK_FOR_ERROR (hstmt);
	ReturnCode = SQLSetStmtAttr (hstmt, SQL_ATTR_ROW_STATUS_PTR, row_status_array, SQL_IS_POINTER);
	CHECK_FOR_ERROR (hstmt);

	// prepare the statement	
	ReturnCode = SQLPrepare (hstmt, (UCHAR *)m_szSQL.GetBuffer(0), SQL_NTS);
	m_szSQL.ReleaseBuffer();
	CHECK_FOR_ERROR (hstmt);
	
	// bind output variables
	ReturnCode = SQLBindCol (hstmt, 1, SQL_C_SLONG, &dss_select_11_array[0].count_t_key, sizeof(dss_select_11_array[0].count_t_key), &dss_select_11_indicators_array[0].count_t_key);
	CHECK_FOR_ERROR (hstmt);

	// ==========
	
	// initialize variables
	m_nUnits = 0;

	// start timer
	m_CTimer.SetStartTime();

	// execute the statement
	ReturnCode = SQLExecute (hstmt);
	CHECK_FOR_ERROR_EXECUTE (hstmt);

	// fetch loop
	while (TRUE) {

		// check for user cancel
		if (CancelXact()) {
				m_CTimer.SetEndTime(m_nUnits, m_nBytes);
				ReturnCode = SQLFreeHandle (SQL_HANDLE_STMT, hstmt);
				CHECK_FOR_ERROR (hstmt);
				return FALSE;
		}

		// fetch the data
		ReturnCode = SQLFetchScroll (hstmt, SQL_FETCH_NEXT, IGNORE);
		CHECK_FOR_ERROR_FETCH (hstmt);

		// if no more data, exit loop
		if (ReturnCode == SQL_NO_DATA)
			break;

		// otherwise, count number of rows returned
		for (iRowLoop = 0; row_status_array[iRowLoop] != SQL_ROW_NOROW && iRowLoop < NUM_ROWS; iRowLoop++) {
			m_nUnits++;
		}

		// if this is the first time through, record response time
		if (m_nUnits <= NUM_ROWS)
			m_CTimer.SetResponseTime();

		// output data to log if requested
		if (OutputResults())
			for (iRowLoop = 0; row_status_array[iRowLoop] != SQL_ROW_NOROW && iRowLoop < NUM_ROWS; iRowLoop++) {
				GetResultsFile() 
					<< dss_select_11_array[iRowLoop].count_t_key << endl;
		}

	}

	// update statistics
	m_nBytes = m_nUnits * sizeof(dss_select_11_array[0]);

	// set end time
	m_CTimer.SetEndTime (m_nUnits, m_nBytes);

	// free handle
	ReturnCode = SQLFreeHandle (SQL_HANDLE_STMT, hstmt);
	CHECK_FOR_ERROR (hstmt);

	// return
	return TRUE;

}
